import matplotlib.pyplot as plt
import os

if __name__ == '__main__':
    with open('list_data_DSE_mean.txt', 'r') as f:
        # 读取每一行，并将其转换为整数，然后创建一个列表
        data_list_DSE_mean = [float(line.strip()) for line in f]
    with open('list_data_DSE_std.txt', 'r') as f:
        # 读取每一行，并将其转换为整数，然后创建一个列表
        data_list_DSE_std = [float(line.strip()) for line in f]

    with open('list_data_DistributedUCB_mean.txt', 'r') as f:
        # 读取每一行，并将其转换为整数，然后创建一个列表
        data_list_DistributedUCB_mean = [float(line.strip()) for line in f]
    with open('list_data_DistributedUCB_std.txt', 'r') as f:
        # 读取每一行，并将其转换为整数，然后创建一个列表
        data_list_DistributedUCB_std = [float(line.strip()) for line in f]

    with open('list_data_GossipUCB_mean.txt', 'r') as f:
        # 读取每一行，并将其转换为整数，然后创建一个列表
        data_list_GossipUCB_mean = [float(line.strip()) for line in f]
    with open('list_data_Gossip_std.txt', 'r') as f:
        # 读取每一行，并将其转换为整数，然后创建一个列表
        data_list_GossipUCB_std = [float(line.strip()) for line in f]

    print(len(data_list_DSE_mean))
    print(len(data_list_DistributedUCB_mean))
    print(len(data_list_GossipUCB_mean))



    while (len(data_list_DSE_mean)!= len(data_list_DistributedUCB_mean)):
        data_list_DistributedUCB_mean.pop(-1)
    while (len(data_list_DSE_mean) != len(data_list_GossipUCB_mean)):
        data_list_GossipUCB_mean.pop(-1)

    while (len(data_list_DSE_mean)!= len(data_list_DistributedUCB_std)):
        data_list_DistributedUCB_std.pop(-1)
    while (len(data_list_DSE_mean) != len(data_list_GossipUCB_std)):
        data_list_GossipUCB_std.pop(-1)

    index_list = range(len(data_list_DSE_mean))

    print(len(data_list_DSE_mean))
    print(len(data_list_DSE_std))

    plt.plot(index_list, data_list_DSE_mean, color='blue', marker='^', markevery=995,markerfacecolor='none',  markersize=10,
             linestyle='--', label='DRRB-bandit')
    plt.fill_between(index_list, [a - b for a, b in zip(data_list_DSE_mean, data_list_DSE_std)] , [a + b for a, b in zip(data_list_DSE_mean, data_list_DSE_std)] , color='lightblue',
                     alpha=0.2)

    plt.plot(index_list, data_list_DistributedUCB_mean, color='red', marker='*', markevery=995,markerfacecolor='none',  markersize=10,
             linestyle=':', label='Dis-UCB')
    plt.fill_between(index_list, [a - b for a, b in zip(data_list_DistributedUCB_mean, data_list_DistributedUCB_std)] , [a + b for a, b in zip(data_list_DistributedUCB_mean, data_list_DistributedUCB_std)] , color='lightcoral',
                     alpha=0.2)

    plt.plot(index_list, data_list_GossipUCB_mean, color='green', marker='o', markevery=995,markerfacecolor='none',  markersize=10,
             linestyle='-', label='Gossip-UCB')
    plt.fill_between(index_list, [a - b for a, b in zip(data_list_GossipUCB_mean, data_list_GossipUCB_std)] , [a + b for a, b in zip(data_list_GossipUCB_mean, data_list_GossipUCB_std)] , color='lightgreen',
                     alpha=0.2)

    # plt.grid(True, linestyle='--')
    # # plt.title('regret')
    # plt.xlabel('Time', fontsize=20)
    # plt.ylabel('Regret', fontsize=20)
    # #plt.ylim(0, 1000)
    # from matplotlib.font_manager import FontProperties
    #
    # font_prop = FontProperties(family='Times New Roman', size=15)
    #
    # plt.legend(prop=font_prop)
    # plt.show()
    #plt.savefig('three_method_8_points.png', dpi=400)

    plt.xlabel(r'Time Slot $t$', fontsize=20)
    plt.ylabel('Regret', fontsize=20)
    plt.xticks(fontsize=20)
    plt.yticks(fontsize=20)
    plt.ylim(0, 6000)
    from matplotlib.font_manager import FontProperties

    font_prop = FontProperties(family='Times New Roman', size=20)
    # plt.legend(prop=font_prop)
    # plt.subplots_adjust(left=0.2, right=0.9, top=0.9, bottom=0.2)
    plt.tight_layout()
    # plt.show()
    plt.savefig('three_method_8_points.png', dpi = 400)
    # plt.savefig(os.path.join('/home/amax/zhr/10K/graph', 'group_3methods.png'), dpi=400)